/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.expressions;

import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ExpressionSource;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.expressions.Expression;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.identifiers.TypeIdentifier;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.FlowValue;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing.ArrayCreationInfo;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.point.ExpressionContext;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.utils.ExpressionASMUtils;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ArrayLiteralExpression
extends SimpleExpression {
    public final TypeIdentifier elementType;
    public final List<Expression> values;

    public ArrayLiteralExpression(ExpressionSource src, TypeIdentifier elementType, List<Expression> values) {
        super(src);
        this.elementType = elementType;
        this.values = values;
    }

    @Override
    public boolean matches(FlowValue node2, ExpressionContext ctx) {
        ArrayCreationInfo creation = (ArrayCreationInfo)node2.getDecoration("mixinextras_persistent_arrayCreationInfo");
        if (creation == null) {
            return false;
        }
        Type newElementType = this.getElementType(node2.getInsn());
        if (newElementType == null || !this.elementType.matches(ctx.pool, newElementType)) {
            return false;
        }
        return ArrayLiteralExpression.inputsMatch(node2, ctx, ctx.allowIncompleteListInputs, this.values.toArray(new Expression[0]));
    }

    private Type getElementType(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 189: {
                return Type.getObjectType((String)((TypeInsnNode)insn).desc);
            }
            case 188: {
                return ExpressionASMUtils.getNewArrayType((IntInsnNode)insn);
            }
        }
        return null;
    }
}

